!!ARBvp1.0
# decal__nodefines.vsh

TEMP r0, r1;

PARAM c[11] = {program.env[0..10]};
PARAM c20 = {0.0, 1.0, 0.5, 0.75};

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.normal;
ATTRIB v2 = vertex.texcoord[0];
ATTRIB v3 = vertex.color.primary;

ALIAS oPos = result.position;
ALIAS oD0 = result.color.primary;
ALIAS oT0 = result.texcoord[0];

# transform position
DP4 oPos.x, v0, c[0];
DP4 oPos.y, v0, c[1];
DP4 oPos.z, v0, c[2];
DP4 oPos.w, v0, c[3];

# pass in coords
MOV oT0, v2;

# calculate lit color
# normal dot light
DP3 r0, v1, c[8];
MAX r0.x, r0, c20.x;

# Modulate with sun color
MUL r0.xyz, c[9], r0.x;

# Add ambient color
MUL r1, c[10], c20.w;			# KLC -- reduce ambient to more closely match PC gamma
ADD r0.xyz, r0, r1;
MOV r0.w, v3.w;

MOV oD0, r0;

END
